/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions.level.dungeon;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class DungeonStructureFeature
extends StructureFeature<CustomJigsawConfiguration> {
    public static String lookingFor = null;

    public DungeonStructureFeature() {
        super(CustomJigsawConfiguration.CODEC, arg -> {
            int z;
            int x = arg.f_197355_().m_45604_();
            double v = DungeonStructureFeature.circularDistance(BlockPos.f_121853_, new Vec3i(x, 0, z = arg.f_197355_().m_45605_()));
            if (v >= (double)((CustomJigsawConfiguration)arg.f_197356_()).minStructureDistance && v <= (double)((CustomJigsawConfiguration)arg.f_197356_()).maxStructureDistance) {
                BlockPos blockPos = new BlockPos((double)arg.f_197355_().m_45604_(), (double)Mth.m_14036_((float)Mth.m_144924_((Random)new Random(), (float)arg.f_197357_().m_141937_(), (float)arg.f_197357_().m_151558_()), (float)((CustomJigsawConfiguration)arg.f_197356_()).minHeight, (float)((CustomJigsawConfiguration)arg.f_197356_()).maxHeight), (double)arg.f_197355_().m_45605_());
                Pools.m_206434_();
                return DungeonStructureFeature.addPieces((PieceGeneratorSupplier.Context<CustomJigsawConfiguration>)arg, PoolElementStructurePiece::new, blockPos, false, true);
            }
            return Optional.empty();
        });
    }

    public static double circularDistance(BlockPos from, Vec3i to) {
        float f = to.m_123341_() - from.m_123341_();
        float g = to.m_123342_() - from.m_123342_();
        float h = to.m_123343_() - from.m_123343_();
        return Math.sqrt(Math.pow(f, 2.0) + Math.pow(g, 2.0) + Math.pow(h, 2.0));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static Optional<PieceGenerator<CustomJigsawConfiguration>> addPieces(PieceGeneratorSupplier.Context<CustomJigsawConfiguration> arg, JigsawPlacement.PieceFactory arg2, BlockPos arg3, boolean bl, boolean bl2) {
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(arg.f_197354_(), arg.f_197355_().f_45578_, arg.f_197355_().f_45579_);
        RegistryAccess registryAccess = arg.f_197360_();
        CustomJigsawConfiguration jigsawConfiguration = (CustomJigsawConfiguration)arg.f_197356_();
        ChunkGenerator chunkGenerator = arg.f_197352_();
        StructureManager structureManager = arg.f_197359_();
        LevelHeightAccessor levelHeightAccessor = arg.f_197357_();
        Predicate predicate = arg.f_197358_();
        StructureFeature.m_67096_();
        Registry registry = registryAccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_55956_((Random)worldgenRandom);
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)jigsawConfiguration.startPool().m_203334_();
        StructurePoolElement structurePoolElement = structureTemplatePool.m_210585_((Random)worldgenRandom);
        if (structurePoolElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece poolElementStructurePiece = arg2.m_210300_(structureManager, structurePoolElement, arg3, structurePoolElement.m_210540_(), rotation, structurePoolElement.m_207470_(structureManager, arg3, rotation));
        BoundingBox boundingBox = poolElementStructurePiece.m_73547_();
        int i = (boundingBox.m_162399_() + boundingBox.m_162395_()) / 2;
        int j = (boundingBox.m_162401_() + boundingBox.m_162398_()) / 2;
        int k = arg3.m_123342_();
        if (!predicate.test(chunkGenerator.m_203495_(QuartPos.m_175400_((int)i), QuartPos.m_175400_((int)k), QuartPos.m_175400_((int)j)))) {
            return Optional.empty();
        }
        int l = boundingBox.m_162396_() + poolElementStructurePiece.m_72647_();
        poolElementStructurePiece.m_6324_(0, k - l, 0);
        return Optional.of((arg10, arg11) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolElementStructurePiece);
            if (jigsawConfiguration.maxDepth() > 0) {
                int v = 262;
                AABB aABB = new AABB((double)(i - v), (double)(k - v), (double)(j - v), (double)(i + v + 1), (double)(k + v + 1), (double)(j + v + 1));
                VoxelShape voxelShape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aABB), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox)), (BooleanOp)BooleanOp.f_82685_);
                JigsawPlacement.Placer placer = new JigsawPlacement.Placer(registry, jigsawConfiguration.maxDepth(), arg2, chunkGenerator, structureManager, (List)list, (Random)worldgenRandom);
                placer.f_210321_.addLast(new JigsawPlacement.PieceState(poolElementStructurePiece, new MutableObject((Object)voxelShape), 0));
                while (!placer.f_210321_.isEmpty()) {
                    JigsawPlacement.PieceState pieceState = (JigsawPlacement.PieceState)placer.f_210321_.removeFirst();
                    placer.m_210333_(pieceState.f_210307_, pieceState.f_210308_, pieceState.f_210309_, bl, levelHeightAccessor);
                }
                Objects.requireNonNull(arg10);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)arg10).m_142679_(arg_0));
            }
        });
    }

    public static class CustomJigsawConfiguration
    implements FeatureConfiguration {
        public static final Codec<CustomJigsawConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(CustomJigsawConfiguration::startPool), (App)Codec.intRange((int)0, (int)100).fieldOf("size").orElseGet(() -> 7).forGetter(CustomJigsawConfiguration::maxDepth), (App)Codec.intRange((int)-300, (int)300).fieldOf("min_height").orElseGet(() -> -300).forGetter(CustomJigsawConfiguration::minHeight), (App)Codec.intRange((int)-300, (int)300).fieldOf("max_height").orElseGet(() -> 300).forGetter(CustomJigsawConfiguration::maxHeight), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_structure_distance").orElseGet(() -> 0).forGetter(CustomJigsawConfiguration::minStructureDistance), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_structure_distance").orElseGet(() -> Integer.MAX_VALUE).forGetter(CustomJigsawConfiguration::maxStructureDistance)).apply((Applicative)instance, CustomJigsawConfiguration::new));
        private final Holder<StructureTemplatePool> startPool;
        private final int maxDepth;
        private final int minHeight;
        private final int maxHeight;
        private final int minStructureDistance;
        private final int maxStructureDistance;

        public CustomJigsawConfiguration(Holder<StructureTemplatePool> arg, int i, int minHeight, int maxHeight, int minStructureDistance, int maxStructureDistance) {
            this.startPool = arg;
            this.maxDepth = i;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.minStructureDistance = minStructureDistance;
            this.maxStructureDistance = maxStructureDistance;
        }

        public int maxDepth() {
            return this.maxDepth;
        }

        public int minHeight() {
            return this.minHeight;
        }

        public int maxHeight() {
            return this.maxHeight;
        }

        public int minStructureDistance() {
            return this.minStructureDistance;
        }

        public int maxStructureDistance() {
            return this.maxStructureDistance;
        }

        public Holder<StructureTemplatePool> startPool() {
            return this.startPool;
        }

        public String toString() {
            return "CustomJigsawConfiguration{startPool=" + this.startPool + ", maxDepth=" + this.maxDepth + ", minHeight=" + this.minHeight + ", maxHeight=" + this.maxHeight + ", minStructureDistance=" + this.minStructureDistance + ", maxStructureDistance=" + this.maxStructureDistance + "}";
        }
    }
}

